unit MainUnit;

//  
//      TPageControl,
//        
// .      TTabControl,
//  TPageControl     
//           
//  .

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, ExtCtrls, StdCtrls, ImgList;

type
  TForm1 = class(TForm)
    PageControl1: TPageControl;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    CBoxTabIndex: TComboBox;
    Button1Panel1: TButton;
    Button2Panel1: TButton;
    Button1Panel2: TButton;
    Button1Panel3: TButton;
    CBoxStyle: TComboBox;
    CBoxTabPosition: TComboBox;
    ImageList1: TImageList;
    LabelTitle: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Bevel1: TBevel;
    Label8: TLabel;
    ButtonExit: TButton;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    TabSheet3: TTabSheet;
    TabSheet4: TTabSheet;
    Bevel2: TBevel;
    Bevel3: TBevel;
    Bevel4: TBevel;
    Bevel5: TBevel;
    procedure PageControl1Change(Sender: TObject);
    procedure CBoxTabIndexChange(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure CBoxStyleChange(Sender: TObject);
    procedure CBoxTabPositionChange(Sender: TObject);
    //       
    procedure ShowButton(Sender: TObject);
    procedure ButtonExitClick(Sender: TObject);
  private
    { Private declarations }
    procedure InitPageControl();
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// -------------------------------------------------------------------
//  ,   PageControl1
// -------------------------------------------------------------------

//  PageControl1
procedure TForm1.InitPageControl();
begin
  //   - 
  PageControl1.TabIndex := 0;
  CBoxTabIndex.ItemIndex := PageControl1.TabIndex;
end;

//     /  PageControl1
procedure TForm1.PageControl1Change(Sender: TObject);
begin
  CBoxTabIndex.ItemIndex := PageControl1.TabIndex;
end;

//    PageControl1
procedure TForm1.FormShow(Sender: TObject);
begin
  InitPageControl();
end;

//     PageControl1
procedure TForm1.CBoxTabIndexChange(Sender: TObject);
begin
   //    PageControl1
   PageControl1.TabIndex := CBoxTabIndex.ItemIndex;
end;

// -------------------------------------------------------------------
//      PageControl1
// -------------------------------------------------------------------

//     
// (    PageControl1.TabPosition = tpTop )
procedure TForm1.CBoxStyleChange(Sender: TObject);
begin
  if PageControl1.TabPosition <> tpTop
  then begin
     MessageDlg(' .'
                + #13#10
                + ' TabPosition = tpTop',
                mtWarning, [mbOk], 0);
     PageControl1.TabPosition := tpTop;
     CBoxTabPosition.ItemIndex := 0;
  end;
  case CBoxStyle.ItemIndex of
  0 : PageControl1.Style := tsTabs;
  1 : PageControl1.Style := tsButtons;
  2 : PageControl1.Style := tsFlatButtons;
  end;
end;

//      PageControl1
// (    PageControl1.Style = tsTabs )
procedure TForm1.CBoxTabPositionChange(Sender: TObject);
begin
  if PageControl1.Style <> tsTabs
  then begin
     MessageDlg(' .'
                + #13#10
                + ' Style = tsTabs',
                mtWarning, [mbOk], 0);
     PageControl1.Style  := tsTabs;
     CBoxStyle.ItemIndex := 0;
  end;
  case CBoxTabPosition.ItemIndex of
    0 : PageControl1.TabPosition := tpTop;
    1 : PageControl1.TabPosition := tpBottom;
    2 : PageControl1.TabPosition := tpLeft;
    3 : PageControl1.TabPosition := tpRight;
  end;
end;

// -------------------------------------------------------------------
//    
// -------------------------------------------------------------------

//       
procedure TForm1.ShowButton(Sender: TObject);
begin
  if  Sender is TButton
  then begin
    with Sender as TButton
    do begin
      ShowMessage(Caption);
    end;
  end;
end;

//  
procedure TForm1.ButtonExitClick(Sender: TObject);
begin
  Close;
end;

end.
